 ; Ŀ
 ;   Gr - get group data for an entity.                                    
 ;   Copyright 1999, 2004 by Rocket Software Ltd.                          
 ;   Don't worry - they're not like teams.                                 
 ; 

 ; Ŀ
 ;   Grrr - get group data for an entity.                                  
 ;   Takes one argument: Enam - the entity name.                           
 ;   Returns a list of lists:                                              
 ;   ((group_name group_ename member_ename_1 member_ename_2 ...) ...)      
 ;   or nil if the entity wasn't a member of any groups.                   
 ;                                                                         
 ;   Note that a group can't contain other groups as such - including one  
 ;   group in another adds its members.                                    
 ; 
 (DEFUN GRRR (enam / entt grlist master mast2)
  (setq entt (entget enam))
 ; Ŀ
 ;   There will be one 330 group in the entity data for each group to      
 ;   which the object belongs.  Note that an entity can belong to          
 ;   multiple groups.  So get a list of their enames.                      
 ;   Also: check to see if this really is a group and not some other type  
 ;   of reactor.  (The 0 group in the entity data for the 330 group in     
 ;   the original entity is (0 . "GROUP"))                                 
 ; 
  (setq num 0)
  (while (setq sub (nth num entt))
         (if (and (= (car sub) 330)
                  (= (cdr (assoc 0 (entget (cdr sub)))) "GROUP"))
             (setq grlist (cons (cdr sub) grlist)))
         (setq num (1+ num)))
 ; Ŀ
 ;   If any of the 330 enames were Groups, add the enames of the entities  
 ;   contained in each group to the appropriate sublist.                   
 ; 
  (if grlist
      (progn
           (setq num 0)
           (while (setq grenam (nth num grlist))
                  (setq subent (entget grenam))
                  (setq newlst (list grenam))
                  (setq subnum 0)
                  (while (setq sub (nth subnum subent))
                         (if (= (car sub) 340)
                             (setq newlst (append newlst (list (cdr sub)))))
                         (setq subnum (1+ subnum)))
                  (setq master (cons newlst master))
                  (setq num (1+ num)))
 ; Ŀ
 ;   Add the group name of each group to the start of its sublist.         
 ;   First get a copy of the master group list.                            
 ; 
           (setq grdict (dictsearch (namedobjdict) "acad_group"))
           (setq grnams (reverse grdict))
 ; Ŀ
 ;   Get the name for each group from the list.                            
 ; 
           (setq num 0)
           (while (setq sub (nth num master))
                  (setq grenam (car sub))
                  (setq grpnam (cadr (member (cons 350 grenam) grnams)))
                  (setq sub (cons (cdr grpnam) sub))
                  (setq mast2 (cons sub mast2))
                  (setq num (1+ num)))))
 mast2)
 ; Ŀ
 ;   Grrr end.                                                             
 ; 

 ; Ŀ
 ;   Gr.                                                                   
 ; 
 (DEFUN C:GR (/ mast2 str strp strq num sub len)
  (if (setq mast2 (grrr (car (entsel "Entity: "))))
      (progn
           (prompt "\nGroups containing this entity:")
           (setq strp " (Contains ")              ; ) balance
           (setq num 0)
           (while (and mast2 (setq sub (nth num mast2)))
                  (setq num (1+ num))
                  (setq len (itoa (- (length sub) 2)))
                  (if (= len "1")                 ; (( balance
                      (setq strq " entity.)")
                      (setq strq " entities.)"))
                  (setq str (strcat "\n" (car sub) strp len strq))
                  (prompt str)))
      (prompt "\nThis entity is not contained in any group."))
 (princ))